#include <windows.h>
#include <mmsystem.h>
#include <memory.h>
#include <string.h>


HMIDIOUT midiOut;
HANDLE hBuffer;


char exePath[1024];



void GSFinish()
{
	if( hBuffer )
	{
		GlobalUnlock( hBuffer );
		GlobalFree( hBuffer );
	}


	if( midiOut )
		midiOutClose( midiOut );
}



void GSReset()
{
	MIDIHDR midiHdr;
	static char sysex[] = { 0xF0, 0x41, 0x10, 0x42, 0x12, 0x40, 0x00, 0x7F, 0x00, 0x41, 0xF7 };


	// MIDI out device
	if( midiOutOpen( &midiOut, (UINT) -1, 0, 0, CALLBACK_NULL ) )
		return;


	// sysex buffer
	hBuffer = GlobalAlloc( GHND, sizeof(sysex) );
	if( !hBuffer )
		return;


	// lock buffer, store data
	midiHdr.lpData = (LPBYTE) GlobalLock( hBuffer );
	if( !midiHdr.lpData )
		return;


	midiHdr.dwBufferLength = sizeof(sysex);
	midiHdr.dwFlags = 0;
	if( midiOutPrepareHeader( midiOut, &midiHdr, sizeof(MIDIHDR) ) )
		return;


	// run sysex
	memcpy( (void *) midiHdr.lpData, &sysex[0], sizeof(sysex) );
	if( midiOutLongMsg( midiOut, &midiHdr, sizeof(MIDIHDR) ) )
		return;


	while( MIDIERR_STILLPLAYING == midiOutUnprepareHeader( midiOut, &midiHdr, sizeof(MIDIHDR)) )
	{}


	return;
}



void RunApp( char *app, char *cmdLine )
{
	strcpy( exePath, app );
	strcat( exePath, " " );
	strcat( exePath, cmdLine );


	//MessageBox( 0, cmdLine, 0, 0 );


	WinExec( exePath, SW_SHOWNORMAL );
}



int PASCAL WinMain (HANDLE hInstance, HANDLE hPrevInstance, LPSTR lpszCmdLine, int nCmdShow)
{
	GSReset();
	GSFinish();


   RunApp( "SCIWIN.EXE", lpszCmdLine );
	//RunApp( "SIERRAW.EXE", lpszCmdLine );
	//RunApp( "SCIWV.EXE", lpszCmdLine );



	return 0;
}

